#include <mail/barbet/service/include/error.h>
#include <yamail/data/serialization/json_writer.h>


namespace barbet {

std::string ServiceCategory::message(int v) const {
    switch(ServiceError(v)) {
        case ServiceError::unexpectedException:
            return "unexpected exception";
        case ServiceError::missingSetting:
            return "missing setting";
        case ServiceError::backupInWrongState:
            return "backup in wrong state";
        case ServiceError::folderIssues:
            return "folder issues";
        case ServiceError::unexpectedCondition:
            return "unexpected condition";
        case ServiceError::frequentBackup:
            return "frequent backup";
        case ServiceError::notificationError:
            return "notification error";
        case ServiceError::unknownRestoreType:
            return "unknown restore type";
        case ServiceError::retriableError:
            return "retriable error";
        case ServiceError::nonRetriableError:
            return "non-retriable error";
    }
    return "unknown enum code";
}

const ServiceCategory& getServiceCategory() {
    static ServiceCategory instance;
    return instance;
}

mail_errors::error_code::base_type make_error_code(ServiceError e) {
    return mail_errors::error_code::base_type(static_cast<int>(e), getServiceCategory());
}

mail_errors::error_code make_error(ServiceError e, std::string what) {
    return mail_errors::error_code(e, std::move(what));
}

}
