#include <mail/barbet/service/include/handlers/archive.h>
#include <mail/barbet/service/include/tasks/archive.h>


#include <mail/barbet/service/include/error.h>
#include <mail/barbet/service/include/hound.h>

#include <mail/barbet/service/include/task_params.h>
#include <mail/mail_errors/error_result/error_result.h>


namespace barbet::archive {

namespace {

inline yamail::expected<EmptyResult> convertHoundResponse(yamail::expected<void>& res) {
    if (!res) {
        return res.get_unexpected();
    }
    return {};
}

}


yamail::expected<archive::DiscardResult> discard(const archive::DiscardParams& params, boost::asio::yield_context yield) {
    constexpr std::string_view action = "cleaning";
    auto houndRes = hound::activateUserAndChangeArchiveState(params.uid, action, *params.client, params.hound, yield);
    return convertHoundResponse(houndRes);
}


yamail::expected<archive::RestoreResult> restore(const archive::RestoreParams& params, boost::asio::yield_context yield) {
    using namespace macs;
    const auto yy = io_result::make_yield_context(yield);
    const auto archive = params.service->users().getArchive(yy);

    if (!archive) {
        return make_unexpected(ServiceError::unexpectedCondition, "archive not found");
    }

    if (ArchiveState::restoration_in_progress == archive->state) {
        return {};
    }

    if (ArchiveState::restoration_error == archive->state) {
        return make_unexpected(ServiceError::unexpectedCondition, "restoration has already been started and failed");
    }

    const ymod_queuedb::RequestId requestId(params.macsParams.sr.requestId);
    ymod_queuedb::TaskId createdTaskId = params.queuedb.addTask(
        boost::lexical_cast<ymod_queuedb::Uid>(params.uid),
        archiveRestoreType(),
        archive::dumpRestoreTaskParams(params.macsParams),
        params.timeout, requestId,
        yy
    );

    LOGDOG_(params.logger, notice,
            log::message="task created",
            log::task_type=archiveRestoreType(),
            log::task_id=createdTaskId);

    constexpr std::string_view action = "restoration";
    auto houndRes = hound::activateUserAndChangeArchiveState(params.uid, action, *params.client, params.hound, yield);
    return convertHoundResponse(houndRes);
}


}
