#pragma once

#include <mail/barbet/service/include/params.h>
#include <mail/barbet/service/include/result.h>

namespace barbet {

inline ymod_queuedb::TaskType fillBackupType() {
    return ymod_queuedb::TaskType("fill_backup");
}

yamail::expected<CreateBackupResult> createBackup(CreateBackupParams params, boost::asio::yield_context yield);
yamail::expected<DeactivateBackupResult> deactivateBackup(DeactivateBackupParams params, boost::asio::yield_context yield);

yamail::expected<void> fillBackup(FillBackupParams params, const ExecOrWait& eow, bool lastTry,
                                  yplatform::task_context_ptr ctx, boost::asio::yield_context yield);

bool backupIsTooFrequent(const macs::BackupStatus& st, std::time_t now, unsigned seconds);

}
