#pragma once

#include <mail/barbet/service/include/params.h>
#include <mail/barbet/service/include/result.h>

namespace barbet {

inline ymod_queuedb::TaskType fillRestoreType() {
    return ymod_queuedb::TaskType("fill_restore");
}

yamail::expected<RestoreResult> restore(RestoreParams params, boost::asio::yield_context yield);
yamail::expected<void> fillRestore(FillRestoreParams params, const ExecOrWait& eow, bool lastTry,
                                   yplatform::task_context_ptr ctx,
                                   boost::asio::yield_context yield);

namespace detail {
std::map <macs::Fid, macs::Folder::Path> makeBackupFoldersPaths(const macs::BackupFolders&);
}
}
