#pragma once

#include <macs/backup.h>

namespace barbet::helpers {

inline macs::Fid resolveFid(const macs::Fid& fid, const macs::Fid& defaultFid,
                     const macs::BackupFidsMapping& mapping) {
    const auto it = mapping.find(fid);
    return it != mapping.end() ? it->second : defaultFid;
}

inline bool isMulcaStid(std::string_view s) {
    constexpr auto mdsOnlyUnitId = "320.";
    size_t lastDotPos = 0;
    size_t dotCount = 0;
    for (size_t i = s.find('.', 0); i < s.size(); i = s.find('.', ++i)) {
        lastDotPos  = std::max(lastDotPos, i);
        ++dotCount;
    }
    
    if (2 != dotCount || s.starts_with(mdsOnlyUnitId)) {
        return false;
    }

    const auto colonPos = s.find(':', lastDotPos);
    return colonPos == s.npos || s[1 + lastDotPos] != 'E';
}

}
