#pragma once

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>
#include <logdog/attributes/mail_attributes.h>
#include <mail/ymod_queuedb/include/logdog.h>
#include <macs_pg/logging.h>


namespace barbet {
namespace log {
LOGDOG_DEFINE_ATTRIBUTE(std::string, execution_status)
using namespace ::logdog::attr;
using namespace ::ymod_queuedb::attr;
}

constexpr static auto formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-barbet-tskv-log"));

inline auto getModuleLogger() {
    return ::logdog::make_log(
        formatter,
        std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, "barbet")
    );
}

using ModuleLogger = decltype(getModuleLogger());

inline auto getContextLogger(const std::string& uid, const std::string& requestId) {
    return ::logdog::bind(getModuleLogger(), log::uid=uid, log::x_request_id=requestId);
}

using ContextLogger = decltype(getContextLogger("", ""));

using MacsPgLog = macs::pg::logging::v2::TypedLog<ContextLogger>;

}
