#pragma once

#include <yamail/expected.h>
#include <mail/http_getter/client/include/client.h>
#include <mail/barbet/service/include/params.h>
#include <mail/barbet/service/include/error.h>
#include <butil/http/arguments.h>

namespace barbet {
namespace {
yamail::expected<void> notify(const std::string& type,
                              const ContextLogger& logger,
                              ymod_queuedb::TaskId id,
                              const http_getter::Endpoint& sendbernar,
                              const ymod_maildb::MacsServiceParams& mp,
                              http_getter::ClientPtr client,
                              boost::asio::yield_context yield) {
    using namespace http_getter::detail::operators;

    HttpArguments post;
    post.add("type", type);
    post.add("uniq_id", std::to_string(static_cast<std::int64_t>(id)) + "_" + mp.sr.requestId);

    http::headers hh;
    hh.add("connection_id", mp.uj.connectionId);
    hh.add("x-yandex-expboxes", mp.uj.expBoxes);
    hh.add("x-yandex-enabledexpboxes", mp.uj.enabledExpBoxes);
    hh.add("x-yandex-clienttype", mp.uj.clientType);
    hh.add("x-yandex-clientversion", mp.uj.clientVersion);
    hh.add("user-agent", mp.uj.userAgent);
    hh.add("yandexuid", mp.uj.yandexUid);
    hh.add("icookie", mp.uj.iCookie);
    hh.add("x-real-ip", mp.sr.realIp);

    auto req = client->toPOST(sendbernar)
            .getArgs("caller"_arg="barbet", "v"_arg="1", "uid"_arg=mp.sr.uid)
            .headers("hdrs"_hdr=hh)
            .postArgs(post);

    yamail::expected<void> ret = make_unexpected(ServiceError::notificationError, "empty notification response");
    client->req(req)->call("sendbernar", [&] (yhttp::response resp) {
        const unsigned status = resp.status;
        if (http_getter::helpers::successCode(status)) {
            ret = yamail::make_expected();
            return http_getter::Result::success;
        } else {
            ret = make_unexpected(ServiceError::notificationError, std::move(resp.body));
            return http_getter::helpers::retriableCode(status) ? http_getter::Result::retry
                                                               : http_getter::Result::fail;
        }
    }, io_result::make_yield_context(yield));

    if (!ret) {
        LOGDOG_(logger, error,
                log::message="cannot notify user",
                log::error_code=ret.error());
    }

    return ret;
}
}

template<class Params>
yamail::expected<void> notifyCreateFailed(const Params& p,
                                          boost::asio::yield_context yield) {
    return notify("create_failed", p. logger, p.taskId, p.sendbernar, p.macsParams, p.client, std::move(yield));
}

template<class Params>
yamail::expected<void> notifyRestoreFailed(const Params& p,
                                           boost::asio::yield_context yield) {
    return notify("restore_failed", p.logger, p.taskId, p.sendbernar, p.macsParams, p.client, std::move(yield));
}

}
