#pragma once

#include <string>
#include <boost/asio/spawn.hpp>
#include <macs_pg/service/service.h>
#include <mail/ymod_queuedb/include/queue.h>
#include <mail/ymod_queuedb_worker/include/exec_or_wait.h>
#include <mail/barbet/service/include/log.h>
#include <mail/http_getter/client/include/client.h>
#include <mail/ymod_maildb/include/params.h>
#include <mail/barbet/ymod_s3/include/client.h>

namespace barbet {

struct MacsAndLoggerParams {
    macs::ServicePtr service;
    ContextLogger logger;
};

using StatusParams = MacsAndLoggerParams;
using SettingsParams = MacsAndLoggerParams;

struct UpdateSettingsParams {
    macs::ServicePtr service;
    ContextLogger logger;
    macs::FidVec fids;
    std::vector<std::string> tabs;
};

struct CreateBackupParams {
    macs::ServicePtr service;
    ContextLogger logger;
    ymod_queuedb::Uid uid;
    ymod_queuedb::Timeout timeout;
    const ymod_queuedb::Queue& queuedb;
    ymod_maildb::MacsServiceParams macsParams;
    unsigned maxMessages;
    unsigned secondsBetweenBackups;
    bool guardedBySetting;
};

using DeactivateBackupParams = MacsAndLoggerParams;
using ExecOrWait = ymod_queuedb::ExecOrWait;

struct FillBackupParams {
    macs::ServicePtr service;
    ContextLogger logger;
    ymod_queuedb::TaskId taskId;
    macs::BackupId backupId;
    http_getter::ClientPtr client;
    http_getter::Endpoint sendbernar;
    ymod_maildb::MacsServiceParams macsParams;
};

struct RestoreParams {
    using Kind = macs::RestoreMethod;

    macs::ServicePtr service;
    ContextLogger logger;
    ymod_queuedb::Uid uid;
    ymod_queuedb::Timeout timeout;
    const ymod_queuedb::Queue& queuedb;
    ymod_maildb::MacsServiceParams macsParams;
    Kind kind;
    bool guardedBySetting;
};

struct FillRestoreParams {
    macs::ServicePtr service;
    ContextLogger logger;
    ymod_queuedb::TaskId taskId;
    macs::Uid uid;
    std::string requestId;
    unsigned messagesChunk;
    unsigned hiddenMessagesChunk;
    macs::BackupId backupId;
    std::time_t now;
    http_getter::ClientPtr client;
    ymod_maildb::MacsServiceParams macsParams;
    http_getter::Endpoint store;
    http_getter::Endpoint blackbox;
    http_getter::Endpoint sendbernar;
};

namespace archive {

using StatusParams = MacsAndLoggerParams;

struct DiscardParams {
    macs::ServicePtr service;
    ContextLogger logger;
    macs::Uid uid;
    http_getter::ClientPtr client;
    http_getter::Endpoint hound;
};

struct RestoreParams {
    macs::ServicePtr service;
    ContextLogger logger;
    macs::Uid uid;
    http_getter::ClientPtr client;
    http_getter::Endpoint hound;
    ymod_queuedb::Timeout timeout;
    const ymod_queuedb::Queue& queuedb;
    ymod_maildb::MacsServiceParams macsParams;
};

struct RestoreTaskParams {
    macs::ServicePtr service;
    ContextLogger logger;
    ymod_queuedb::TaskId taskId;
    macs::Uid uid;
    std::string requestId;
    unsigned int updateInterval;
    ymod_maildb::MacsServiceParams macsParams;
    ymod_s3::ClientPtr s3;
    std::string s3Bucket;

    http_getter::ClientPtr client;
    http_getter::Endpoint store;
    http_getter::Endpoint blackbox;
    http_getter::Endpoint sendbernar;
};

}

}
