#pragma once

#include <yamail/expected.h>
#include <macs/backup.h>
#include <macs/backup_error.h>
#include <macs/types.h>
#include <macs/archive.h>
#include <macs/freezing_info.h>
#include <mail/webmail/http_api_helpers/include/result.h>

namespace barbet {

struct StatusResult {
    std::optional<macs::Backup> primary;
    std::optional<macs::Backup> additional;
    std::optional<macs::Restore> restore;
};

struct SettingsResult {
    SettingsResult() = default;
    SettingsResult(macs::BackupSettings);

    std::vector<macs::Fid> fids;
    std::vector<std::string> tabs;
};

struct CreateBackupResult {
    macs::BackupId backup_id;
};

using http_api::EmptyResult;

using RestoreResult = EmptyResult;
using DeactivateBackupResult = EmptyResult;

namespace archive {

using DiscardResult = EmptyResult;
using RestoreResult = EmptyResult;

struct StatusResult {
    macs::UserState user_state;
    std::optional<macs::ArchiveState> archive_state;
    std::optional<int32_t> message_count;
    std::optional<int32_t> restored_message_count;
};

}

}
