#pragma once

#include <yamail/expected.h>
#include <mail/barbet/service/include/params.h>
#include <mail/barbet/service/include/error.h>


namespace barbet {

template<class YY>
yamail::expected<void> guardBySetting(macs::ServicePtr service, bool guardedBySetting, const YY& yy) {
    static const std::string barbetSetting = "mail_b2c_can_use_backup";
    macs::settings::ParametersPtr settings = service->settings().getParameters(
        {barbetSetting},
        yy
    );

    auto b = settings->single_settings.find(barbetSetting);
    if (guardedBySetting && (b == settings->single_settings.end() || b->second != "on")) {
        return make_unexpected(ServiceError::missingSetting, barbetSetting);
    } else {
        return yamail::make_expected();
    }
}

}
