#pragma once

#include <mail/barbet/service/include/params.h>
#include <mail/http_getter/client/include/module.h>
#include <mail/ymod_maildb/include/module.h>

namespace barbet {

ymod_queuedb::TaskArgs dumpFillBackupParams(macs::BackupId id, const ymod_maildb::MacsServiceParams& params);
FillBackupParams parseFillBackupParams(const ymod_queuedb::Task& task,
                                       const http_getter::Endpoint& sendbernar,
                                       const ymod_maildb::Module& maildb,
                                       const http_getter::ClientModule& getter);


ymod_queuedb::TaskArgs dumpFillRestoreParams(macs::BackupId id, std::time_t now, const ymod_maildb::MacsServiceParams& params);
FillRestoreParams parseFillRestoreParams(const ymod_queuedb::Task& task,
                                         unsigned messagesChunk, unsigned hiddenMessagesChunk,
                                         const http_getter::Endpoint& store,
                                         const http_getter::Endpoint& blackbox,
                                         const http_getter::Endpoint& sendbernar,
                                         const ymod_maildb::Module& maildb,
                                         const http_getter::ClientModule& client);

namespace archive {
ymod_queuedb::TaskArgs dumpRestoreTaskParams(const ymod_maildb::MacsServiceParams& params);
RestoreTaskParams parseRestoreTaskParams(const ymod_queuedb::Task& task,
                                        const ymod_maildb::Module& maildb,
                                        ymod_s3::ClientPtr s3,
                                        std::string s3Bucket,
                                        unsigned int updateInterval,
                                        const http_getter::ClientModule& getter,
                                        const http_getter::Endpoint& store,
                                        const http_getter::Endpoint& blackbox,
                                        const http_getter::Endpoint& sendbernar);
}

}
