#pragma once

#include <boost/asio/spawn.hpp>

namespace barbet::archive {

struct ArchiveChunk {
    std::string key;
    std::int64_t last_mid;
    std::int64_t count; 
};

struct ArchiveMessage {
    std::int64_t received_date;
    std::string st_id;
    std::string folder_type;
    bool is_shared;
};

class Postman {
public:
    using Message = ArchiveMessage;
    using Mid = std::string;
    virtual ~Postman() = default;

    virtual Mid restore(const Message& msg, boost::asio::yield_context yield) const = 0;
};

class Unarchiver {
public:
    using YieldCtx = boost::asio::yield_context;
    virtual ~Unarchiver() = default;

    void restore(const std::string& uid, const std::int64_t previouslyRestored, const Postman& postman, YieldCtx yield) const;

protected:
    virtual std::vector<ArchiveChunk> getUserArchiveChunks(const std::string& uid, YieldCtx yield) const = 0;
    virtual std::vector<ArchiveMessage> getArchiveMessages(const std::string& key, YieldCtx yield) const = 0;

    virtual void restorationProgress(std::int64_t currentlyRestored, YieldCtx yield) const = 0;
    virtual void restorationError(std::int64_t totallyRestored, YieldCtx yield) const = 0;
    virtual void restorationComplete(std::int64_t totallyRestored, YieldCtx yield) const = 0;
};

}
