#include <mail/barbet/service/include/result.h>
#include <boost/range/adaptor/map.hpp>
#include <boost/range/algorithm.hpp>


namespace barbet {
namespace {
auto toTabNames(std::vector<macs::Tab::Type> tabs) {
    std::vector<std::string> tabNames;
    tabNames.reserve(tabs.size());
    boost::range::transform(tabs, std::back_inserter(tabNames), [](auto& element){
        return element.toString();
    });
    return tabNames;
}
}

SettingsResult::SettingsResult(macs::BackupSettings settings)
    : fids(std::move(settings.fids))
    , tabs(toTabNames(std::move(settings.tabs)))
{ }

}
