#include <mail/barbet/service/include/task_params.h>
#include <mail/ymod_maildb/include/reflection.h>
#include <boost/fusion/adapted/struct/define_struct.hpp>
#include <yamail/data/deserialization/json_reader.h>
#include <yamail/data/serialization/json_writer.h>
#include <macs_pg/service/factory.h>

BOOST_FUSION_DEFINE_STRUCT((barbet)(reflection), FillBackup,
    (ymod_maildb::MacsServiceParams, macs)
    (macs::BackupId, id)
)

BOOST_FUSION_DEFINE_STRUCT((barbet)(reflection), FillRestore,
    (ymod_maildb::MacsServiceParams, macs)
    (macs::BackupId, id)
    (std::time_t, now)
)

namespace barbet {

namespace yds = yamail::data::serialization;
namespace ydd = yamail::data::deserialization;

ymod_queuedb::TaskArgs dumpFillBackupParams(macs::BackupId id, const ymod_maildb::MacsServiceParams& params) {
    reflection::FillBackup cb;
    cb.macs = params;
    cb.id = id;

    return ymod_queuedb::TaskArgs(
        std::make_optional(
            yds::JsonWriter<reflection::FillBackup>(cb).result()
        )
    );
}

FillBackupParams parseFillBackupParams(const ymod_queuedb::Task& task,
                                       const http_getter::Endpoint& sendbernar,
                                       const ymod_maildb::Module& maildb,
                                       const http_getter::ClientModule& getter) {
    const auto reflect = ydd::JsonReader<reflection::FillBackup>(
        task.taskArgs
    ).result();

    const auto logger = getContextLogger(
        std::to_string(static_cast<std::int64_t>(task.uid)), reflect.macs.sr.requestId
    );

    return FillBackupParams {
        .service=maildb.service(
            reflect.macs.sr, reflect.macs.uj, std::make_shared<MacsPgLog>(logger),
            macs::pg::masterOnly),
        .logger=logger,
        .taskId=task.taskId,
        .backupId=reflect.id,
        .client=getter.create(
            reflect.macs.sr.requestId, http_getter::withLog(
                getter.httpLogger(
                    std::to_string(static_cast<std::int64_t>(task.uid)),
                    reflect.macs.sr.requestId
                )
            )
        ),
        .sendbernar=sendbernar,
        .macsParams=reflect.macs
    };
}

ymod_queuedb::TaskArgs dumpFillRestoreParams(macs::BackupId id, std::time_t now, const ymod_maildb::MacsServiceParams& params) {
    reflection::FillRestore cb;
    cb.macs = params;
    cb.id = id;
    cb.now = now;

    return ymod_queuedb::TaskArgs(
        std::make_optional(
            yds::JsonWriter<reflection::FillRestore>(cb).result()
        )
    );
}

FillRestoreParams parseFillRestoreParams(const ymod_queuedb::Task& task,
                                         unsigned messagesChunk, unsigned hiddenMessagesChunk,
                                         const http_getter::Endpoint& store,
                                         const http_getter::Endpoint& blackbox,
                                         const http_getter::Endpoint& sendbernar,
                                         const ymod_maildb::Module& maildb,
                                         const http_getter::ClientModule& getter) {
    const auto reflect = ydd::JsonReader<reflection::FillRestore>(
        task.taskArgs
    ).result();

    const auto logger = getContextLogger(
        std::to_string(static_cast<std::int64_t>(task.uid)), reflect.macs.sr.requestId
    );

    return FillRestoreParams {
        .service=maildb.service(
            reflect.macs.sr, reflect.macs.uj, std::make_shared<MacsPgLog>(logger),
            macs::pg::masterOnly),
        .logger=logger,
        .taskId=task.taskId,
        .uid=reflect.macs.sr.uid,
        .requestId=reflect.macs.sr.requestId,
        .messagesChunk=messagesChunk,
        .hiddenMessagesChunk=hiddenMessagesChunk,
        .backupId=reflect.id,
        .now=reflect.now,
        .client=getter.create(
            reflect.macs.sr.requestId, http_getter::withLog(
                getter.httpLogger(
                    std::to_string(static_cast<std::int64_t>(task.uid)),
                    reflect.macs.sr.requestId
                )
            )
        ),
        .macsParams=reflect.macs,
        .store=store,
        .blackbox=blackbox,
        .sendbernar=sendbernar
    };
}


namespace archive {

ymod_queuedb::TaskArgs dumpRestoreTaskParams(const ymod_maildb::MacsServiceParams& params) {
    return ymod_queuedb::TaskArgs(
        std::make_optional(
            yds::JsonWriter<ymod_maildb::MacsServiceParams>(params).result()
        )
    );
}

RestoreTaskParams parseRestoreTaskParams(const ymod_queuedb::Task& task,
                                        const ymod_maildb::Module& maildb,
                                        ymod_s3::ClientPtr s3,
                                        std::string s3Bucket,
                                        unsigned int updateInterval,
                                        const http_getter::ClientModule& getter,
                                        const http_getter::Endpoint& store,
                                        const http_getter::Endpoint& blackbox,
                                        const http_getter::Endpoint& sendbernar) {

    const auto macs = ydd::JsonReader<ymod_maildb::MacsServiceParams>(
        task.taskArgs
    ).result();

    const auto logger = getContextLogger(
        std::to_string(static_cast<std::int64_t>(task.uid)), macs.sr.requestId
    );

    return RestoreTaskParams{
        .service=maildb.service(
            macs.sr, macs.uj, std::make_shared<MacsPgLog>(logger),
            macs::pg::masterOnly
        ),
        .logger=logger,

        .taskId=task.taskId,
        .uid=macs.sr.uid,
        .requestId=macs.sr.requestId,
        .updateInterval=updateInterval,
        .macsParams=macs,

        .s3=std::move(s3),
        .s3Bucket=std::move(s3Bucket),

        .client=getter.create(
            macs.sr.requestId, http_getter::withLog(
                getter.httpLogger(
                    std::to_string(static_cast<std::int64_t>(task.uid)),
                    macs.sr.requestId
                )
            )
        ),
        .store=store,
        .blackbox=blackbox,
        .sendbernar=sendbernar
    };
}

}

}
