#include <mail/barbet/service/include/unarchiver.h>
#include <spdlog/details/format.h>


namespace barbet::archive {

void Unarchiver::restore(const std::string& uid, const std::int64_t previouslyRestored, const Postman& postman, YieldCtx yield) const {
    const auto archiveChunks = getUserArchiveChunks(uid, yield);       
    std::int64_t currentlyRestored = 0;
    for (const auto& chunk : archiveChunks) {
        if ((currentlyRestored + chunk.count) <= previouslyRestored) {
            currentlyRestored += chunk.count;
            continue;
        }

        const auto messages = getArchiveMessages(chunk.key, yield);
        if (messages.size() != static_cast<size_t>(chunk.count)) {
            restorationError(currentlyRestored, yield);
            throw std::runtime_error(fmt::format("archive chunk size mismatch: expected={}, got={}", chunk.count, messages.size()));
        }

        std::int64_t startInChunk = 0;
        if (previouslyRestored > currentlyRestored) {
            startInChunk = previouslyRestored - currentlyRestored;
            currentlyRestored = previouslyRestored;
        }

        for (size_t i = startInChunk; i < messages.size(); ++i) {
            const auto& archiveMsg = messages[i];
            try {
                postman.restore(archiveMsg, yield);
            } catch (const boost::coroutines::detail::forced_unwind&) {
                throw;
            } catch(...) {
                restorationError(currentlyRestored, yield);
                throw;
            }
            restorationProgress(++currentlyRestored, yield);
        }
    }
    restorationComplete(std::max(previouslyRestored, currentlyRestored), std::move(yield));
}

}
