from cpython cimport *
from libcpp.vector cimport vector
from libcpp.memory cimport shared_ptr

from mail.unistat.cpp.cython.logs cimport *
from mail.unistat.cpp.cython.meters cimport *
from mail.ymod_queuedb_worker.unistat.cpp.metrics cimport *
cimport mail.unistat.cpp.cython.run_cpp


cdef extern from "mail/barbet/unistat/cpp/metrics.h" namespace "unistat":
    cdef cppclass Logs:
        Logs(...)



def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[Logs] cppLogs
    for l in pyLogs:
        if isinstance(l, HttpClientLog):
            cppLogs.push_back(
                Logs((<HttpClientLog>l).__impl)
            )
        elif isinstance(l, SupervisorLog):
            cppLogs.push_back(
                Logs((<SupervisorLog>l).__impl)
            )
        elif isinstance(l, WorkerMetricsLog):
            cppLogs.push_back(
                Logs((<WorkerMetricsLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")
    mail.unistat.cpp.cython.run_cpp.run(host, port, cppLogs, yplatformLogPath, logLevel)
