#pragma once

#include <aws/core/utils/threading/Executor.h>
#include <yplatform/reactor.h>

namespace ymod_s3::detail {

class AwsExecutor final : public Aws::Utils::Threading::Executor {
public:
    ~AwsExecutor() final = default;

    explicit AwsExecutor(yplatform::reactor_ptr reactor) : reactor_{std::move(reactor)} {}

protected:
    using Handler = std::function<void()>;

    bool SubmitToThread(Handler&& handler) final {
        reactor_->post(std::forward<Handler>(handler));
        return true;
    }

private:
    yplatform::reactor_ptr reactor_;
};

}
