#pragma once

#include <aws/core/utils/logging/LogSystemInterface.h>
#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>


namespace ymod_s3::detail {


namespace log {

constexpr static auto aws_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-aws-log"));
using namespace ::logdog::attr;

}

inline auto getModuleLogger(const std::string& logName) {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE, logName);
    return ::logdog::make_log(log::aws_formatter, logger);
}

using Logger = decltype(getModuleLogger(""));

class AwsLogger final : public Aws::Utils::Logging::LogSystemInterface {
private:
    using AwsLogLevel = Aws::Utils::Logging::LogLevel;
    Logger log_;
    AwsLogLevel level_;

    void Log(AwsLogLevel log_level, const char* tag, const char* format_str, ...) final {
        LOGDOG_(log_, error, logdog::attr::message = "usage of deprecated function");
        callLogImpl(log_level, tag, format_str);
    }

public:
    AwsLogger(const std::string& logName = "", AwsLogLevel level = AwsLogLevel::Off)
            : log_(getModuleLogger(logName)), level_(level) {}

    ~AwsLogger() final = default;

    [[nodiscard]] AwsLogLevel GetLogLevel() const final {
        return level_;
    }

    void LogStream(AwsLogLevel log_level, const char* tag,
                   const Aws::OStringStream& message_stream) final {
        callLogImpl(log_level, tag, message_stream.str().c_str());
    }

    void callLogImpl(AwsLogLevel log_level, const char* tag, const char* msg) {
        using namespace ::logdog::attr;
        switch (log_level) {
#ifdef _case
#error "_case already defined"
#else
#define _case(_A, _L) case AwsLogLevel::_A: return LOGDOG_(log_, error, message=msg, where_name=tag)
            _case(Fatal, error);
            _case(Error, error);
            _case(Warn, warning);
            _case(Info, notice);
            _case(Debug, debug);
            _case(Trace, notice);
#undef _case
#endif
            case AwsLogLevel::Off:
                break;
        }
    }

    void Flush() final {}
};


}
