#pragma once

#include <optional>

#include <yplatform/module.h>
#include <mail/barbet/ymod_s3/include/client.h>
#include <yamail/data/deserialization/ptree.h>
#include <yamail/data/serialization/json_writer.h>
#include <yamail/data/serialization/ptree.h>
#include <yamail/data/reflection.h>


YREFLECTION_ADAPT_ENUM(Aws::Utils::Logging::LogLevel,
                       Off,
                       Fatal,
                       Error,
                       Warn,
                       Info,
                       Debug,
                       Trace
)

YREFLECTION_ADAPT_ENUM(Aws::Http::Scheme,
                       HTTP,
                       HTTPS
)

YREFLECTION_ADAPT_ENUM(Aws::Client::AWSAuthV4Signer::PayloadSigningPolicy,
                       RequestDependent,
                       Always,
                       Never
)

BOOST_FUSION_DEFINE_STRUCT(
    (ymod_s3)(Settings)(Credentials), TVM,
    (std::string, module)
    (std::string, s3_id)
    (std::string, service_id)
)

BOOST_FUSION_DEFINE_STRUCT(
    (ymod_s3)(Settings)(Credentials), Simple,
    (std::string, access_key_id)
    (std::string, secret_key)
    (std::string, session_token)
)

BOOST_FUSION_DEFINE_STRUCT(
    (ymod_s3)(Settings)(Credentials), Credentials,
    (std::optional<ymod_s3::Settings::Credentials::Simple>, simple)
    (std::optional<ymod_s3::Settings::Credentials::TVM>,    tvm)
)

BOOST_FUSION_DEFINE_STRUCT(
    (ymod_s3)(Settings), Client,
    (std::string, user_agent)
    (Aws::Http::Scheme, scheme)
    (std::string, endpoint_override)
    (bool, verify_ssl)

    (long, connect_timeout_ms)
    (long, request_timeout_ms)

    (std::optional<std::string>, ca_path)
    (std::optional<std::string>, ca_file)
    (std::optional<std::string>, region)
    (std::optional<Aws::Client::AWSAuthV4Signer::PayloadSigningPolicy>, sign_payloads)
    (std::optional<bool>, use_virtual_addressing)
)


BOOST_FUSION_DEFINE_STRUCT(
    (ymod_s3)(Settings), Settings,
    (ymod_s3::Settings::Credentials::Credentials, credentials)
    (ymod_s3::Settings::Client, client)
    (std::string, logger)
    (Aws::Utils::Logging::LogLevel, log_level)
    (std::string, stats_logger)
)


namespace ymod_s3::Settings {

using boost::fusion::operators::operator==;

Settings readSettings(const yplatform::ptree& cfg) {
    return yamail::data::deserialization::fromPtree<Settings>(cfg);
}

}
