from sendr_aiohttp.handler import request_schema, response_schema

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.base import success_response_schema
from mail.beagle.beagle.api.schemas.mail_list import (
    mail_list_list_request_query_schema, mail_list_list_response_schema, mail_list_put_schema,
    mail_list_response_schema, mail_list_schema
)
from mail.beagle.beagle.api.schemas.path import mail_list_id_org_id_request_schema, org_id_request_schema
from mail.beagle.beagle.core.actions.mail_list.create import CreateMailListAction
from mail.beagle.beagle.core.actions.mail_list.delete import DeleteMailListAction
from mail.beagle.beagle.core.actions.mail_list.get import GetMailListAction
from mail.beagle.beagle.core.actions.mail_list.get_list import GetListListMailAction
from mail.beagle.beagle.core.actions.mail_list.update import UpdateMailListAction


class MailListListHandler(BaseHandler):
    @request_schema(org_id_request_schema, location='match_info')
    @request_schema(mail_list_list_request_query_schema, location='query')
    @response_schema(mail_list_list_response_schema)
    async def get(self):
        """
        Получить список всех рассылок организации.
        """
        data = await self.get_data()
        mail_list_list = await self.run_action(GetListListMailAction, **data)
        return self.make_response({'data': mail_list_list})

    @request_schema(org_id_request_schema, location='match_info')
    @request_schema(mail_list_schema, location='json')
    @response_schema(mail_list_response_schema)
    async def post(self):
        """
        Создание рассылки.
        """
        data = await self.get_data()
        mail_list = await self.run_action(CreateMailListAction, generate_cache=True, **data)
        return self.make_response({'data': mail_list})


class MailListHandler(BaseHandler):
    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @response_schema(mail_list_response_schema)
    async def get(self):
        """
        Получить информацию о рассылке.
        """
        data = await self.get_data()
        mail_list = await self.run_action(GetMailListAction, **data)
        return self.make_response({'data': mail_list})

    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(mail_list_put_schema, location='json')
    @response_schema(mail_list_response_schema)
    async def put(self):
        """
        Обновление рассылки.
        """
        data = await self.get_data()
        mail_list = await self.run_action(UpdateMailListAction, **data)
        return self.make_response({'data': mail_list})

    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @response_schema(success_response_schema)
    async def delete(self):
        """
        Удаление рассылки.
        """
        data = await self.get_data()
        await self.run_action(DeleteMailListAction, **data)
        return self.make_response(None)
