from sendr_aiohttp.handler import request_schema, response_schema

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.base import success_response_schema
from mail.beagle.beagle.api.schemas.mail_list_responsible import (
    mail_list_responsible_request_schema, mail_list_responsible_response_schema, uid_request_schema
)
from mail.beagle.beagle.api.schemas.path import mail_list_id_org_id_request_schema
from mail.beagle.beagle.core.actions.mail_list_responsible.create import CreateMailListResponsibleAction
from mail.beagle.beagle.core.actions.mail_list_responsible.delete import DeleteMailListResponsibleAction
from mail.beagle.beagle.core.actions.mail_list_responsible.get import GetMailListResponsibleAction


class MailListResponsibleHandler(BaseHandler):
    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(mail_list_responsible_request_schema, location='query')
    @response_schema(mail_list_responsible_response_schema)
    async def get(self):
        """
        Получение списка ответственных за рассылку.
        """
        data = await self.get_data()
        mail_list_responsible = await self.run_action(GetMailListResponsibleAction, **data)
        return self.make_response({'data': mail_list_responsible})

    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(uid_request_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self):
        """
        Добавление ответственных за рассылку.
        """
        data = await self.get_data()
        await self.run_action(CreateMailListResponsibleAction, **data)
        return self.make_response(None)

    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(uid_request_schema, location='json')
    @response_schema(success_response_schema)
    async def delete(self):
        """
        Удаление ответственных за рассылку.
        """
        data = await self.get_data()
        await self.run_action(DeleteMailListResponsibleAction, **data)
        return self.make_response(None)
