from sendr_aiohttp.handler import request_schema, response_schema

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.recipients import directory_recipients_response_schema, recipients_get_schema
from mail.beagle.beagle.conf import settings
from mail.beagle.beagle.core.actions.recipients import RecipientsAction
from mail.beagle.beagle.core.entities.enums import OrganizationType

response_schemas = {
    OrganizationType.DIRECTORY: directory_recipients_response_schema
}


class RecipientsHandler(BaseHandler):
    @request_schema(recipients_get_schema, location='query')
    @response_schema(response_schemas[settings.CURRENT_ORGANIZATION_TYPE])
    async def get(self):
        """
        Получить развернутый список получателей рассылки.
        """
        data = await self.get_data()
        subscriptions = await self.run_action(RecipientsAction, **data)
        return self.make_response({'response': subscriptions})
