from sendr_aiohttp.handler import request_schema, response_schema

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.support import support_request_schema, support_response_schema
from mail.beagle.beagle.core.actions.support import SupportAction


class SupportHandler(BaseHandler):
    @request_schema(support_request_schema, location='query')
    @response_schema(support_response_schema)
    async def get(self):
        """
        Выдает список подписчиков по юиду рассылки.
        https://wiki.yandex-team.ru/mail/pdd/bigml/#ruchkadljasapporta
        """
        data = await self.get_data()
        subscribers = await self.run_action(SupportAction, **data)
        return self.make_response({'response': subscribers})
