from sendr_aiohttp.handler import request_schema, response_schema

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.base import success_response_schema
from mail.beagle.beagle.api.schemas.path import sync_request_schema
from mail.beagle.beagle.api.schemas.sync import sync_post_schema
from mail.beagle.beagle.core.actions.sync.sync_organization import QueueSyncCurrentOrganizationAction


class SyncHandler(BaseHandler):
    @request_schema(sync_request_schema, location='match_info')
    @request_schema(sync_post_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self):
        """
        Ручка для синхронизации организации.
        """
        data = await self.get_data()
        self.logger.context_push(client=data.pop('client'))
        await self.run_action(QueueSyncCurrentOrganizationAction, **data)
        return self.make_response(None)
