from sendr_aiohttp.handler import request_schema, response_schema

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.base import success_response_schema
from mail.beagle.beagle.api.schemas.path import mail_list_id_org_id_request_schema
from mail.beagle.beagle.api.schemas.unit_subscription import (
    unit_id_request_schema, unit_subscription_request_json_schema, unit_subscription_request_schema,
    unit_subscription_response_schema
)
from mail.beagle.beagle.core.actions.unit_subscription.create import CreateUnitSubscriptionAction
from mail.beagle.beagle.core.actions.unit_subscription.delete import DeleteUnitSubscriptionAction
from mail.beagle.beagle.core.actions.unit_subscription.get import GetUnitSubscriptionAction


class UnitSubscriptionHandler(BaseHandler):
    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(unit_subscription_request_schema, location='query')
    @response_schema(unit_subscription_response_schema)
    async def get(self):
        """
        Получить список подписанных на рассылку юнитов.
        """
        data = await self.get_data()
        unit_subscriptions = await self.run_action(GetUnitSubscriptionAction, **data)
        return self.make_response({'data': unit_subscriptions})

    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(unit_subscription_request_json_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self):
        """
        Создать подписку юнита на рассылку.
        """
        data = await self.get_data()
        await self.run_action(CreateUnitSubscriptionAction, **data)
        return self.make_response(None)

    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(unit_id_request_schema, location='json')
    @response_schema(success_response_schema)
    async def delete(self):
        """
        Удалить подписку юнита на рассылку.
        """
        data = await self.get_data()
        await self.run_action(DeleteUnitSubscriptionAction, **data)
        return self.make_response(None)
