from sendr_aiohttp.handler import request_schema, response_schema

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.user import user_schema, user_uid_org_id_schema
from mail.beagle.beagle.core.actions.user.get import GetUserAction


class UserUIDHandler(BaseHandler):
    @request_schema(user_uid_org_id_schema, location='query')
    @response_schema(user_schema)
    async def get(self):
        """
        Информация о пользователе.
        """
        data = await self.get_data()
        user = await self.run_action(GetUserAction, **data)
        return self.make_response(user)
