from sendr_aiohttp.handler import request_schema, response_schema

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.api.schemas.base import success_response_schema
from mail.beagle.beagle.api.schemas.path import mail_list_id_org_id_request_schema
from mail.beagle.beagle.api.schemas.user_subscription import (
    uid_request_schema, user_subscription_request_json_schema, user_subscription_request_schema,
    user_subscription_response_schema
)
from mail.beagle.beagle.core.actions.user_subscription.create import CreateUserSubscriptionAction
from mail.beagle.beagle.core.actions.user_subscription.delete import DeleteUserSubscriptionAction
from mail.beagle.beagle.core.actions.user_subscription.get import GetUserSubscriptionAction


class UserSubscriptionHandler(BaseHandler):
    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(user_subscription_request_schema, location='query')
    @response_schema(user_subscription_response_schema)
    async def get(self):
        """
        Получить список подписчиков по рассылке.
        """
        data = await self.get_data()
        user_subscription_list = await self.run_action(GetUserSubscriptionAction, **data)
        return self.make_response({'data': user_subscription_list})

    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(user_subscription_request_json_schema, location='json')
    @response_schema(success_response_schema)
    async def post(self):
        """
        Подписать пользователя на рассылку.
        """
        data = await self.get_data()
        data['inviter_uid'] = self.tvm.default_uid
        await self.run_action(CreateUserSubscriptionAction, **data)
        return self.make_response(None)

    @request_schema(mail_list_id_org_id_request_schema, location='match_info')
    @request_schema(uid_request_schema, location='json')
    @response_schema(success_response_schema)
    async def delete(self):
        """
        Удалить подписчика из рассылки.
        """
        data = await self.get_data()
        await self.run_action(DeleteUserSubscriptionAction, **data)
        return self.make_response(None)
