from aiohttp import web

from sendr_qstats.http.aiohttp import get_registry_handler

from mail.beagle.beagle.api.handlers.base import BaseHandler
from mail.beagle.beagle.core.actions.ping_db import PingDBAction
from mail.beagle.beagle.utils.stats import REGISTRY


class PingHandler(BaseHandler):
    async def get(self):
        return web.Response(text='pong')


class PingDBHandler(BaseHandler):
    async def get(self):
        await self.run_action(PingDBAction)
        return web.Response(text='pong')


UnistatHandler = get_registry_handler(REGISTRY)
