from mail.beagle.beagle.api.handlers.mail_list import MailListHandler, MailListListHandler
from mail.beagle.beagle.api.handlers.mail_list_responsible import MailListResponsibleHandler
from mail.beagle.beagle.api.handlers.unit_subscription import UnitSubscriptionHandler
from mail.beagle.beagle.api.handlers.user_subscription import UserSubscriptionHandler
from mail.beagle.beagle.api.routes.base import Url

MAIL_LIST_ROUTES = (
    # Mail List
    Url(r'/mail_list/{org_id:\d+}', MailListListHandler, name='v1_mail_list_list'),
    Url(r'/mail_list/{org_id:\d+}/{mail_list_id:\d+}', MailListHandler, name='v1_mail_list'),

    # Mail List Responsible
    Url(r'/mail_list/{org_id:\d+}/{mail_list_id:\d+}/responsible', MailListResponsibleHandler,
        name='mail_list_responsible'),

    # Unit Subscription
    Url(r'/mail_list/{org_id:\d+}/{mail_list_id:\d+}/unit_subscription', UnitSubscriptionHandler,
        name='unit_subscription'),

    # User Subscription
    Url(r'/mail_list/{org_id:\d+}/{mail_list_id:\d+}/user_subscription', UserSubscriptionHandler,
        name='user_subscription'),
)
