import ujson
from marshmallow import Schema, fields, validate


class BaseSchema(Schema):
    class Meta:
        json_module = ujson
        strict = True


class BaseResponseSchema(BaseSchema):
    code = fields.Integer()
    status = fields.String()
    data = fields.Dict(default=None)  # type: ignore


class PaginatedRequestSchema(BaseSchema):
    limit = fields.Integer(missing=100, validate=validate.Range(min=1, max=100))
    offset = fields.Integer(missing=0, validate=validate.Range(min=0))


class SuccessResponseSchema(BaseResponseSchema):
    code = fields.Constant(200)  # type: ignore
    status = fields.Constant('success')  # type: ignore


class FailDataSchema(BaseSchema):
    message = fields.String()
    params = fields.Dict()


class FailResponseSchema(BaseResponseSchema):
    code = fields.Integer()
    status = fields.Constant('fail')  # type: ignore
    data = fields.Nested(FailDataSchema)  # type: ignore


success_response_schema = SuccessResponseSchema()
fail_response_schema = FailResponseSchema()
paginated_schema = PaginatedRequestSchema()
