from marshmallow import fields
from marshmallow_enum import EnumField

from mail.beagle.beagle.api.schemas.base import BaseSchema, SuccessResponseSchema
from mail.beagle.beagle.core.entities.enums import MailListType


class MailListDescriptionSchema(BaseSchema):
    ru = fields.String()
    en = fields.String()


class MailListSchema(BaseSchema):
    org_id = fields.Integer(dump_only=True)
    mail_list_id = fields.Integer(dump_only=True)
    mail_list_type = EnumField(MailListType, by_value=True, dump_only=True)
    uid = fields.Integer(dump_only=True)
    username = fields.String(required=True)
    description = fields.Nested(MailListDescriptionSchema)
    created = fields.DateTime(dump_only=True)
    updated = fields.DateTime(dump_only=True)


class MailListPutSchema(BaseSchema):
    description = fields.Nested(MailListDescriptionSchema)


class MailListResponseSchema(SuccessResponseSchema):
    data = fields.Nested(MailListSchema)  # type: ignore


class MailListListResponseSchema(SuccessResponseSchema):
    data = fields.Nested(MailListSchema, many=True)  # type: ignore


class MailListListRequestQuerySchema(BaseSchema):
    name_query = fields.String()


mail_list_schema = MailListSchema()
mail_list_put_schema = MailListPutSchema()
mail_list_response_schema = MailListResponseSchema()
mail_list_list_response_schema = MailListListResponseSchema()
mail_list_list_request_query_schema = MailListListRequestQuerySchema()
