from marshmallow import fields

from mail.beagle.beagle.api.schemas.base import BaseSchema, PaginatedRequestSchema, SuccessResponseSchema


class UIDRequestSchema(BaseSchema):
    uid = fields.Integer(required=True)


class MailListResponsibleRequestSchema(PaginatedRequestSchema):
    uid = fields.Integer()


class MailListResponsibleSchema(BaseSchema):
    org_id = fields.Integer(required=True)
    uid = fields.Integer(required=True)
    mail_list_id = fields.Integer(required=True)
    created = fields.DateTime(dump_only=True)
    updated = fields.DateTime(dump_only=True)


class MailListResponsibleResponseSchema(SuccessResponseSchema):
    data = fields.Nested(MailListResponsibleSchema, many=True)  # type: ignore


uid_request_schema = UIDRequestSchema()
mail_list_responsible_response_schema = MailListResponsibleResponseSchema()
mail_list_responsible_request_schema = MailListResponsibleRequestSchema()
