from marshmallow import fields

from mail.beagle.beagle.api.schemas.base import BaseSchema


class OrgIdRequestSchema(BaseSchema):
    org_id = fields.Integer(required=True)


class MailListIdOrgIdRequestSchema(OrgIdRequestSchema):
    mail_list_id = fields.Integer(required=True)


class SyncRequestSchema(BaseSchema):
    client = fields.String(required=True)


org_id_request_schema = OrgIdRequestSchema()
sync_request_schema = SyncRequestSchema()
mail_list_id_org_id_request_schema = MailListIdOrgIdRequestSchema()
