from marshmallow import fields, post_dump

from mail.beagle.beagle.api.schemas.base import BaseSchema


class RecipientsGetSchema(BaseSchema):
    email_to = fields.String(required=True)
    email_from = fields.String(required=True)


class DirectoryRecipientSchema(BaseSchema):
    email = fields.String(required=True)
    uid = fields.Integer(required=True)

    @post_dump
    def lower_email(self, data):
        data['email'] = data['email'].lower()
        return data


class DirectoryRecipientsSchema(BaseSchema):
    subscriptions = fields.Nested(DirectoryRecipientSchema, many=True)


class DirectoryRecipientsResponseSchema(BaseSchema):
    status = fields.Constant('ok')  # type: ignore
    response = fields.Nested(DirectoryRecipientsSchema)


recipients_get_schema = RecipientsGetSchema()
directory_recipients_response_schema = DirectoryRecipientsResponseSchema()
