from marshmallow import fields

from mail.beagle.beagle.api.schemas.base import BaseSchema


class SupportRequestSchema(BaseSchema):
    list_uid = fields.Integer(required=True)


class SubscriberSchema(BaseSchema):
    uid = fields.Integer()
    stype = fields.String()


class SupportResponseSchema(BaseSchema):
    response = fields.Nested(SubscriberSchema, many=True)
    status = fields.Constant('ok')  # type: ignore


support_request_schema = SupportRequestSchema()
support_response_schema = SupportResponseSchema()
