from marshmallow import fields
from marshmallow_enum import EnumField

from mail.beagle.beagle.api.schemas.base import BaseSchema, PaginatedRequestSchema, SuccessResponseSchema
from mail.beagle.beagle.core.entities.enums import SubscriptionType


class UnitIdRequestSchema(BaseSchema):
    unit_id = fields.Integer(required=True)


class UnitSubscriptionSchema(BaseSchema):
    org_id = fields.Integer()
    mail_list_id = fields.Integer()
    subscription_type = EnumField(SubscriptionType, by_value=True)
    unit_id = fields.Integer()
    created = fields.DateTime(dump_only=True)
    updated = fields.DateTime(dump_only=True)


class UnitSubscriptionResponseSchema(SuccessResponseSchema):
    data = fields.Nested(UnitSubscriptionSchema, many=True)  # type: ignore


class UnitSubscriptionRequestSchema(PaginatedRequestSchema):
    unit_id = fields.Integer()


class UnitSubscriptionRequestJsonSchema(UnitIdRequestSchema):
    subscription_type = EnumField(SubscriptionType, by_value=True, required=True)


unit_id_request_schema = UnitIdRequestSchema()
unit_subscription_response_schema = UnitSubscriptionResponseSchema()
unit_subscription_request_schema = UnitSubscriptionRequestSchema()
unit_subscription_request_json_schema = UnitSubscriptionRequestJsonSchema()
