from marshmallow import fields
from marshmallow_enum import EnumField

from mail.beagle.beagle.api.schemas.base import BaseSchema, PaginatedRequestSchema, SuccessResponseSchema
from mail.beagle.beagle.core.entities.enums import SubscriptionType


class UIDRequestSchema(BaseSchema):
    uid = fields.Integer(required=True)


class UserSubscriptionRequestJsonSchema(BaseSchema):
    uid = fields.Integer(required=True)
    subscription_type = EnumField(SubscriptionType, by_value=True, required=True)


class UserSubscriptionRequestSchema(PaginatedRequestSchema):
    uid = fields.Integer()


class UserSubscriptionSchema(BaseSchema):
    org_id = fields.Integer(required=True)
    mail_list_id = fields.Integer(required=True)
    uid = fields.Integer(required=True)
    subscription_type = EnumField(SubscriptionType, by_value=True, required=True)
    created = fields.DateTime(dump_only=True)
    updated = fields.DateTime(dump_only=True)


class UserSubscriptionResponseSchema(SuccessResponseSchema):
    data = fields.Nested(UserSubscriptionSchema, many=True)  # type: ignore


uid_request_schema = UIDRequestSchema()
user_subscription_request_schema = UserSubscriptionRequestSchema()
user_subscription_request_json_schema = UserSubscriptionRequestJsonSchema()
user_subscription_response_schema = UserSubscriptionResponseSchema()
