import asyncio

import click
import uvloop
from aiohttp import web
from click import ClickException

from mail.beagle.beagle.mocks.directory.app import DirectoryMockApplication
from mail.beagle.beagle.utils.logging import configure_logging


@click.command()
@click.option('--host', default='127.0.0.1', help='Bind address')
@click.option('--port', default=8003, help='Port number')
@click.option('--mock')
def cli(host, port, mock):
    asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    configure_logging()

    mocks = {
        'directory': DirectoryMockApplication,
    }

    if mock not in mocks:
        raise ClickException(f'Unknown mock: {mock}')

    app: web.Application = mocks[mock]()
    web.run_app(app, port=port, host=host)
