import asyncio

import click
import uvloop
from aiohttp import web

from mail.beagle.beagle.api.app import BeagleApplication
from mail.beagle.beagle.utils.logging import configure_logging


@click.command()
@click.option('--host', default='127.0.0.1', help='Bind address')
@click.option('--port', default=8001, help='Port number')
def cli(host, port):
    """Starts api web server.
    Usage: manage.py runserver --host=127.0.0.1 --port=8001
    """

    asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    configure_logging()

    app = BeagleApplication()
    web.run_app(app, port=port, host=host)
