import asyncio

import click
import uvloop

from mail.beagle.beagle.taskq.app import BeagleWorkerApplication
from mail.beagle.beagle.utils.logging import configure_logging


@click.command()
@click.option('--host', default='127.0.0.1', help='Bind address')
@click.option('--port', default=8002, help='Port number')
def cli(host, port):
    """Starts api web server.
    Usage: manage.py runserver --host=127.0.0.1 --port=8002
    """

    asyncio.set_event_loop_policy(uvloop.EventLoopPolicy())
    configure_logging()

    app = BeagleWorkerApplication()
    app.start(host, port)
