import os

from sendr_core.exceptions import CoreFailError
from sendr_settings import Config

from mail.beagle.beagle.core.entities.enums import OrganizationType

overwrite_file = os.environ.get('BEAGLE_EXTRA_CONFIG_FILE', '/config/local/settings.py')
settings = Config.load_from_env('resfs/file/settings', overwrite_file=overwrite_file)

try:
    settings.CURRENT_ORGANIZATION_TYPE = OrganizationType(settings.CURRENT_ORGANIZATION_TYPE)
except ValueError:
    raise CoreFailError(f'Unknown CURRENT_ORGANIZATION_TYPE: {settings.CURRENT_ORGANIZATION_TYPE}')
