from sendr_aiopg.action import BaseDBAction as BDBAction
from sendr_core.action import BaseAction as BAction
from sendr_taskqueue.worker.storage.action import BaseAsyncDBAction

from mail.beagle.beagle.core.context import CoreContext
from mail.beagle.beagle.core.entities.enums import TaskType
from mail.beagle.beagle.interactions import InteractionClients
from mail.beagle.beagle.storage import Storage, StorageContext


class BaseAction(BAction):
    context = CoreContext()

    def __init__(self):
        super().__init__()
        self._clients = InteractionClients(self.logger, self.request_id)

    @property
    def clients(self) -> InteractionClients:
        return self._clients

    async def _run(self):
        with self.logger:
            async with self.clients:
                return await super()._run()


class BaseDBAction(BaseAsyncDBAction, BDBAction, BaseAction):
    storage: Storage  # https://st.yandex-team.ru/SWATTOOLS-2

    task_type = TaskType.RUN_ACTION
    storage_context_cls = StorageContext
