from typing import ClassVar, Optional

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.entities.mail_list import MailList
from mail.beagle.beagle.core.exceptions import MailListNotFoundError
from mail.beagle.beagle.storage.exceptions import MailListNotFound


class BaseMailListAction(BaseDBAction):
    for_update: ClassVar[bool] = False

    def __init__(self,
                 org_id: Optional[int] = None,
                 mail_list_id: Optional[int] = None,
                 mail_list: Optional[MailList] = None,
                 ):
        super().__init__()
        self.org_id: Optional[int] = org_id
        self.mail_list_id: Optional[int] = mail_list_id
        self.mail_list: Optional[MailList] = mail_list

    async def pre_handle(self):
        await super().pre_handle()
        if self.mail_list is None:
            assert self.org_id is not None and self.mail_list_id is not None
            try:
                self.mail_list = await self.storage.mail_list.get(
                    org_id=self.org_id,
                    mail_list_id=self.mail_list_id,
                    for_update=self.for_update,
                )
            except MailListNotFound:
                raise MailListNotFoundError
        elif self.org_id is None and self.mail_list_id is None:
            self.org_id = self.mail_list.org_id
            self.mail_list_id = self.mail_list.mail_list_id
        else:
            raise ValueError('Either mail_list or (org_id, mail_list_id) must be None.')
