from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.entities.mail_list import MailList
from mail.beagle.beagle.core.exceptions import MailListNotFoundError
from mail.beagle.beagle.storage.exceptions import MailListNotFound


class GetMailListAction(BaseDBAction):
    def __init__(self, org_id: int, mail_list_id: int):
        super().__init__()
        self.org_id = org_id
        self.mail_list_id = mail_list_id

    async def handle(self) -> MailList:
        try:
            return await self.storage.mail_list.get(self.org_id, self.mail_list_id)
        except MailListNotFound:
            raise MailListNotFoundError
