from typing import List, Optional

from sendr_utils import alist

from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.entities.mail_list import MailList
from mail.beagle.beagle.core.exceptions import OrganizationNotFoundError
from mail.beagle.beagle.storage.exceptions import OrganizationNotFound


class GetListListMailAction(BaseDBAction):
    def __init__(self, org_id: int, name_query: Optional[str] = None):
        super().__init__()
        self.org_id = org_id
        self.name_query = name_query

    async def pre_handle(self) -> None:
        try:
            await self.storage.organization.get(self.org_id)
        except OrganizationNotFound:
            raise OrganizationNotFoundError

    async def handle(self) -> List[MailList]:
        return await alist(self.storage.mail_list.find(self.org_id, name_query=self.name_query))
