from typing import Optional

from mail.beagle.beagle.core.actions.mail_list.base import BaseMailListAction
from mail.beagle.beagle.core.entities.mail_list import MailList, MailListDescription


class UpdateMailListAction(BaseMailListAction):
    transact = True
    for_update = True

    def __init__(self,
                 org_id: Optional[int] = None,
                 mail_list_id: Optional[int] = None,
                 mail_list: Optional[MailList] = None,
                 description: Optional[dict] = None,
                 ):
        super().__init__(
            org_id=org_id,
            mail_list_id=mail_list_id,
            mail_list=mail_list,
        )
        self.description: Optional[dict] = description

    async def handle(self) -> MailList:
        assert self.mail_list is not None
        if self.description:
            self.mail_list.description = MailListDescription(**self.description)
        return await self.storage.mail_list.save(self.mail_list)
