from mail.beagle.beagle.core.actions.mail_list.base import BaseMailListAction
from mail.beagle.beagle.core.entities.mail_list_responsible import MailListResponsible
from mail.beagle.beagle.core.exceptions import MailListResponsibleAlreadyExistsError, UserNotFoundError
from mail.beagle.beagle.storage.exceptions import MailListResponsibleAlreadyExists, UserNotFound


class CreateMailListResponsibleAction(BaseMailListAction):
    def __init__(self, org_id: int, mail_list_id: int, uid: int):
        super().__init__(org_id=org_id, mail_list_id=mail_list_id)
        self.uid: int = uid

    async def pre_handle(self) -> None:
        await super().pre_handle()
        assert self.org_id
        try:
            await self.storage.user.get(org_id=self.org_id, uid=self.uid)
        except UserNotFound:
            raise UserNotFoundError

    async def handle(self):
        mail_list_responsible_entity = MailListResponsible(org_id=self.org_id,
                                                           mail_list_id=self.mail_list_id,
                                                           uid=self.uid)
        try:
            await self.storage.mail_list_responsible.create(mail_list_responsible_entity)
        except MailListResponsibleAlreadyExists:
            raise MailListResponsibleAlreadyExistsError
