from mail.beagle.beagle.core.actions.mail_list.base import BaseMailListAction
from mail.beagle.beagle.core.exceptions import MailListResponsibleNotFoundError
from mail.beagle.beagle.storage.exceptions import MailListResponsibleNotFound


class DeleteMailListResponsibleAction(BaseMailListAction):
    transact = True

    def __init__(self, org_id: int, mail_list_id: int, uid: int):
        super().__init__(org_id=org_id, mail_list_id=mail_list_id)
        self.uid: int = uid

    async def handle(self) -> None:
        assert self.org_id and self.mail_list_id
        try:
            mail_list_responsible = await self.storage.mail_list_responsible.get(org_id=self.org_id,
                                                                                 mail_list_id=self.mail_list_id,
                                                                                 uid=self.uid,
                                                                                 for_update=True)
        except MailListResponsibleNotFound:
            raise MailListResponsibleNotFoundError
        await self.storage.mail_list_responsible.delete(mail_list_responsible)
