from typing import List, Optional

from sendr_utils import alist

from mail.beagle.beagle.core.actions.mail_list.base import BaseMailListAction
from mail.beagle.beagle.core.entities.mail_list_responsible import MailListResponsible


class GetMailListResponsibleAction(BaseMailListAction):
    def __init__(self,
                 org_id: int,
                 mail_list_id: int,
                 uid: Optional[int] = None,
                 limit: Optional[int] = None,
                 offset: Optional[int] = None
                 ):
        super().__init__(org_id=org_id, mail_list_id=mail_list_id)
        self.uid: Optional[int] = uid
        self.limit: Optional[int] = limit
        self.offset: Optional[int] = offset

    async def handle(self) -> List[MailListResponsible]:
        assert self.org_id and self.mail_list_id
        mail_list_responsible = await alist(self.storage.mail_list_responsible.find(org_id=self.org_id,
                                                                                    mail_list_id=self.mail_list_id,
                                                                                    uid=self.uid,
                                                                                    limit=self.limit,
                                                                                    offset=self.offset))
        return mail_list_responsible
