from mail.beagle.beagle.core.actions.base import BaseDBAction
from mail.beagle.beagle.core.actions.mail_list.delete import DeleteMailListAction
from mail.beagle.beagle.core.entities.organization import Organization
from mail.beagle.beagle.core.entities.serial import Serial
from mail.beagle.beagle.core.exceptions import OrganizationAlreadyExistsError
from mail.beagle.beagle.storage.exceptions import OrganizationAlreadyExists, OrganizationNotFound


class CreateOrganizationAction(BaseDBAction):
    transact = True

    def __init__(self, org_id: int):
        super().__init__()
        self.org_id = org_id

    async def handle(self):
        try:
            organization = await self.storage.organization.create(Organization(org_id=self.org_id))
        except OrganizationAlreadyExists:
            raise OrganizationAlreadyExistsError

        await self.storage.serial.create(Serial(org_id=organization.org_id))
        return organization


class DeleteOrganizationAction(BaseDBAction):
    transact = True

    def __init__(self, org_id: int):
        super().__init__()
        self.org_id = org_id

    async def handle(self) -> None:
        try:
            org = await self.storage.organization.get(self.org_id)
        except OrganizationNotFound:
            self.logger.warning(f'Org {self.org_id} already deleted')
        else:
            org = await self.storage.organization.delete(org)
            async for ml in self.storage.mail_list.find(org_id=org.org_id):
                ml = await DeleteMailListAction(mail_list=ml).run()
